package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.T1CompletionReqDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class T1ReportCompletionClient {


    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * 导入车卡关系接口
     * @param t1CompletionReqDTO
     * @return
     */
    public Response reportCompletionCmcc(T1CompletionReqDTO t1CompletionReqDTO) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL+  "/t1/reportCompletionCmcc", t1CompletionReqDTO, Response.class);
    }

}
