package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.CtccNoticeDTO;
import com.cusc.nirvana.user.rnr.fp.dto.InstructionDTO;
import com.cusc.nirvana.user.rnr.fp.dto.t1.CmccNoticeDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.fp.dto.CuccNoticeDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @author yubo
 * @since 2022-06-16 18:05
 */
@Service
public class T1DataUploadClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * T1开户信息上报
     *
     * @author: zitan.ren
     **/
    public Response uploadUserInfoAndFile(MgCardNoticeDTO mgCardNoticeDTO) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/t1/data/uploadUserInfoAndFile", mgCardNoticeDTO, Object.class);
    }

    /**
     * T1指令采集
     *
     * @author: zitan.ren
     **/
    public Response instruction(InstructionDTO instructionDTO) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/t1/data/instruction", instructionDTO, Object.class);
    }


    public Response jfCuccNotice(CuccNoticeDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/t1/data/jfCuccNotice",
                dto,
                Object.class);
    }

    public Response jfCmccNotice(CmccNoticeDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/t1/data/jfCmccNotice",
                dto,
                Object.class);
    }

    public Response vwCuccNotice(CuccNoticeDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/t1/data/cuccNotice",
                dto,
                Object.class);
    }

    public Response vwCmccNotice(CmccNoticeDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/t1/data/cmccNotice",
                dto,
                Object.class);
    }

    public Response vwCtccNotice(CtccNoticeDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/t1/data/ctccNotice",
                dto,
                Object.class);
    }
}
