package com.cusc.nirvana.user.rnr.fp.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.*;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class SimVehicleRelClient {

    private final static String IMPORT_SIM_URL = UserRnrFpConstant.USER_RNR_FP_URL + "/simvehcilerel/importSim";

    private final static String IMPORT_SIM_VEHICLE_URL = UserRnrFpConstant.USER_RNR_FP_URL + "/simvehcilerel/importSimVehicle";

    private final static String GET_ICCID_BY_VIN_URL = UserRnrFpConstant.USER_RNR_FP_URL + "/simvehcilerel/getIccidByVin";

    private final static String GET_BINDING_STATUS_URL = UserRnrFpConstant.USER_RNR_FP_URL + "/simvehcilerel/queryByIccids";

    private final static String QUERY_BY_ICCIDS_URL = UserRnrFpConstant.USER_RNR_FP_URL + "/simvehcilerel/queryByIccids";

    private final static String QUERY_SIM_VEHICLE_PAGE_URL = UserRnrFpConstant.USER_RNR_FP_URL + "/simvehcilerel/querySimVehiclePage";

    private final static String UN_BIND_URL = UserRnrFpConstant.USER_RNR_FP_URL + "/simvehcilerel/unbind";

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * 导入sim卡信息
     * @param importSimParamDTO
     * @return
     */
    public Response<ImportSimResult> importSim(ImportSimParamDTO importSimParamDTO) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrFp, IMPORT_SIM_URL, importSimParamDTO, ImportSimResult.class);
    }

    /**
     * 导入车卡关系接口
     * @param bindingDTO
     * @return
     */
    public Response<SimVehicleBindingResult> importSimVehicle(SimVehicleBindingDTO bindingDTO) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrFp, IMPORT_SIM_VEHICLE_URL, bindingDTO, SimVehicleBindingResult.class);
    }

    /**
     * 车卡关系解绑
     * @param requestDTO
     * @return
     */
    public Response<SimVehicleDTO> unbind(BindRequestDTO requestDTO) {
        return RnrMgRestTemplateUtils.postForResponse(restTemplateRnrFp, UN_BIND_URL, requestDTO, SimVehicleDTO.class);
    }

    /**
     * 车辆绑卡查询
     * @param vin
     * @return
     */
    public Response<List<VinIccidDTO>> getIccidByVin(String vin){
        return RnrMgRestTemplateUtils.getForResponseList(restTemplateRnrFp, GET_ICCID_BY_VIN_URL + "?vin=" + vin, VinIccidDTO.class);
    }

    /**
     * 查看车卡绑定状态
     * @param iccid
     * @param vin
     * @return
     */
    public Response<VinIccidDTO> getBindingInfo(String iccid, String vin) {
        Map<String, String> params = new HashMap<>();
        params.put("iccid", iccid);
        params.put("vin", vin);
        Response response = restTemplateRnrFp.getForObject(GET_BINDING_STATUS_URL + "?iccid={iccid}&vin={vin}", Response.class, params);
        return Response.createSuccess(JSON.parseObject(JSONObject.toJSONString(response.getData()), VinIccidDTO.class));
    }

    /**
     * 获取车卡绑定分页信息列表
     * @param queryDTO
     * @return
     */
    public Response<PageResult<SimVehicleResultDTO>> querySimVehiclePage(SimVehicleQueryDTO queryDTO) {
        Response<PageResult<SimVehicleResultDTO>> response = RnrMgRestTemplateUtils.postForResponsePageResult(restTemplateRnrFp, QUERY_SIM_VEHICLE_PAGE_URL,
                queryDTO, SimVehicleResultDTO.class);
        return response;
    }

    /**
     * 查询多个iccid的详细信息
     * @param listDTO
     * @return
     */
    public Response<List<IccidDetailDTO>> queryByIccids(IccidListDTO listDTO) {
        return RnrMgRestTemplateUtils.postForResponseList(restTemplateRnrFp, QUERY_BY_ICCIDS_URL, listDTO, IccidDetailDTO.class);
    }

}
