package com.cusc.nirvana.user.rnr.fp.client;

import javax.annotation.Resource;

import com.cusc.nirvana.user.rnr.fp.dto.QueryRnrResultDTO;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dto.OrganizationDTO;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.VinCardResultDTO;
import com.cusc.nirvana.user.rnr.fp.dto.rnrv1.RnrStatusReqDTO;
import com.cusc.nirvana.user.rnr.fp.dto.rnrv1.SuccessDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;

/**
 * @author stayAnd
 * @date 2022/5/18
 */
@Component
public class Rnrv1Client {
	@Resource
	private RestTemplate restTemplateRnrFp;

	public Response<SuccessDTO> queryRnrStatus(@RequestBody RnrStatusReqDTO dto){
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/rnrv1/query/rnr-status"
               , dto, SuccessDTO.class);
	}

	public Response<String> queryCmccRnrStatus(@RequestBody QueryRnrResultDTO dto){
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/cmccRrnr/queryRnrResult"
				, dto, String.class);
	}

}
