package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dto.OrganizationDTO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * Description: 组织client
 * <br />
 * CreateDate 2022-05-27 16:52:10
 *
 * @author yuyi
 **/
@Component
@Slf4j
public class OrganClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;


    /**
     * Description: 根据用户id查询组织id
     * <br />
     * CreateDate 2022-05-27 17:23:37
     *
     * @author yuyi
     **/
    public Response<String> getOrganIdByUserId(UserOrganDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/organ"
                + "/getOrganIdByUserId", bean, String.class);
    }

    /**
     * Description: 根据用户id查询车企子组织信息
     * <br />
     * CreateDate 2022-05-27 17:23:37
     *
     * @author yuyi
     **/
    public Response<OrganizationDTO> getCarSubOrganByUserId(UserOrganDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/organ"
                + "/getCarSubOrganByUserId", bean, OrganizationDTO.class);
    }

    /**
     * Description: 根据组织id查询车企子组织信息
     * <br />
     * CreateDate 2022-05-27 17:23:37
     *
     * @author yuyi
     **/
    public Response<OrganizationDTO> getCarSubOrganByOrganId(OrganizationDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/organ"
                + "/getCarSubOrganByOrganId", bean, OrganizationDTO.class);
    }

    /**
     * Description: 根据用户id查询车企顶级组织
     * <br />
     * CreateDate 2022-05-27 17:23:37
     *
     * @author yuyi
     **/
    public Response<OrganizationDTO> getCarOrgan(UserOrganDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/organ"
                + "/getCarOrgan", bean, OrganizationDTO.class);
    }

    /**
     * Description: 根据组织查询编码获取上一级的车企组织id
     * <br />
     * CreateDate 2022-05-27 17:23:37
     *
     * @author yuyi
     **/
    public Response<OrganizationDTO> getCarSubOrganByQueryCode(OrganizationDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/organ"
                + "/getCarSubOrganByQueryCode", bean, OrganizationDTO.class);
    }
}
