package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.*;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

/**
 * @author stayAnd
 * @date 2022/5/18
 */
@Component
public class NewVinCardClient {
	@Resource
	private RestTemplate restTemplateRnrFp;

	public Response<VinCardResultDTO> queryUnBindCardByVin(@RequestBody VinCardQueryDTO queryDTO){
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/newVinCard/queryUnBindCardByVin",queryDTO,VinCardResultDTO.class);
	}

	public Response<VinCardResultDTO> queryBindCardByVin(@RequestBody VinCardQueryDTO queryDTO){
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/newVinCard/queryBindCardByVin",queryDTO,VinCardResultDTO.class);
	}

	public Response<VinCardCheckResultDTO> checkVinCard(@RequestBody VinCardCheckDTO vinCardCheckDTO){
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/newVinCard/checkVinCard",vinCardCheckDTO,VinCardCheckResultDTO.class);
	}

	public Response<VinCheckResultDTO> checkVin(@RequestBody VinCheckRequestDTO requestDTO){
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/newVinCard/checkVin",requestDTO,VinCheckResultDTO.class);
	}
}
