package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.SurplusQueryRequestDTO;
import com.cusc.nirvana.user.rnr.fp.dto.SurplusQueryResponseDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.dto.SurplusConfirmDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @author yubo
 * @since 2022-04-20 11:21
 */
@Service
public class FpSurplusCardBindClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;


    public Response<String> surplusCardBind(RnrRelationDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/fp/surplusCard/bind", dto, String.class);
    }

    public Response<String> surplusCardBindDirect(RnrRelationDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/fp/surplusCard/bindDirect", dto, String.class);
    }


    public Response<Boolean> confirm(SurplusConfirmDto dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/fp/surplusCard/confirm", dto, Boolean.class);
    }

    public Response<SurplusQueryResponseDTO> queryResult(SurplusQueryRequestDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/fp/surplusCard/queryResult", dto, SurplusQueryResponseDTO.class);
    }
}
