package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.MgCheckProgressDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgSearchCardAuthDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 审核进度查询 client
 *
 */
@Component
@Slf4j
public class FpSearchCardAuthClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * 单车进度查询
     * @param
     */
    public Response<List<MgSearchCardAuthDTO>> getMgSearchCardAuthDTO(MgRnrCardInfoDTO bean) {
        return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL+  "/fpSearchCardAuth/car-auth1",
                bean,
                MgSearchCardAuthDTO.class);
    }

    /**
     * 审核进度列表查询
     * @param
     */
    public Response<PageResult<MgCheckProgressDTO>> getCheckProgressList(MgCheckProgressDTO bean) {
        return RnrFpRestTemplateUtils.postForResponsePageResult(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL+  "/fpSearchCardAuth/getCheckProgress",
                bean,
                MgCheckProgressDTO.class);
    }

}
