package com.cusc.nirvana.user.rnr.fp.client;

/**
 * @author stayAnd
 * @date 2022/7/29
 */

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.RnrOrderDetailDTO;
import com.cusc.nirvana.user.rnr.fp.dto.RnrOrderListQueryDTO;
import com.cusc.nirvana.user.rnr.fp.dto.RnrOrderListResponseDTO;
import com.cusc.nirvana.user.rnr.fp.dto.VinCardDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Slf4j
public class FpRnrOrderClient {

	@Autowired
	@Qualifier("restTemplateRnrFp")
	RestTemplate restTemplateRnrFp;


	public Response<PageResult<RnrOrderListResponseDTO>> pageListQuery(RnrOrderListQueryDTO dto){
		return RnrFpRestTemplateUtils.postForResponsePageResult(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/order/pageListQuery", dto, RnrOrderListResponseDTO.class);
	}

	public Response<PageResult<VinCardDTO>> queryCardPageByOrderId(MgRnrCardInfoDTO dto){
		return RnrFpRestTemplateUtils.postForResponsePageResult(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/order/queryCardPageByOrderId", dto, VinCardDTO.class);
	}

	public Response<RnrOrderDetailDTO> queryOrderDetail(String orderId){
		return RnrFpRestTemplateUtils.getForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/order/queryOrderDetail?orderId="+orderId, RnrOrderDetailDTO.class);
	}
}
