package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.OcrNpReqDTO;
import com.cusc.nirvana.user.rnr.fp.dto.OcrNpRespDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * @author yubo
 * @since 2022-06-15 18:28
 */
@Component
public class OcrClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * Description: ocr
     **/
    public Response<OcrNpRespDTO> ocr(OcrNpReqDTO bean) {
//        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/ocr/doOcr"
//                , bean, OcrNpRespDTO.class);
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/ocr/doOcr" ,bean, OcrNpRespDTO.class);

    }
}
