package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.FpT1UploadStatusDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * @className: IFpT1UploadStatusClient
 * @description: T1上报状态
 * @author: jk
 * @date: 2022/7/27 9:33
 * @version: 1.0
 **/
@Service
public class FpT1UploadStatusClient {
    @Autowired
    @Qualifier("restTemplateRnrFp")
    private RestTemplate restTemplateRnrFp;

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<FpT1UploadStatusDTO>> queryByList(FpT1UploadStatusDTO bean) {
        return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpT1UploadStatus/queryByList", bean,
                FpT1UploadStatusDTO.class);
    }

    public Response<FpT1UploadStatusDTO> update(FpT1UploadStatusDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpT1UploadStatus/update", bean,
                FpT1UploadStatusDTO.class);
    }
}
