package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.FpRnrRelationInfoDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 实名关联信息(FpRnrRelationInfo) client 
 *
 * @author yuy336
 * @since 2022-04-14 20:42:56
 */
@Component
public class FpRnrRelationInfoClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<FpRnrRelationInfoDTO>> queryByPage(FpRnrRelationInfoDTO bean) {
		return RnrFpRestTemplateUtils.postForResponsePageResult(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrRelationInfo/queryByPage", bean, FpRnrRelationInfoDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<FpRnrRelationInfoDTO> getByUuid(FpRnrRelationInfoDTO bean) {
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL +  "/fpRnrRelationInfo/getByUuid",
               bean,
                FpRnrRelationInfoDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<FpRnrRelationInfoDTO>> queryByList(FpRnrRelationInfoDTO bean) {
		 return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrRelationInfo/queryByList", bean,
                FpRnrRelationInfoDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(FpRnrRelationInfoDTO bean) {
	   return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrRelationInfo/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(FpRnrRelationInfoDTO bean) {
		return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrRelationInfo/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(FpRnrRelationInfoDTO bean) {
		return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrRelationInfo/deleteById", bean, Response.class);
    }
}
