package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.FpRnrProtocolManageDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * (FpRnrProtocolManage) client 
 *
 * @author yuy336
 * @since 2022-06-01 10:52:33
 */
@Component
public class FpRnrProtocolManageClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<FpRnrProtocolManageDTO>> queryByPage(FpRnrProtocolManageDTO bean) {
		return RnrFpRestTemplateUtils.postForResponsePageResult(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrProtocolManage/queryByPage", bean, FpRnrProtocolManageDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<FpRnrProtocolManageDTO> getByUuid(FpRnrProtocolManageDTO bean) {
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL +  "/fpRnrProtocolManage/getByUuid",
               bean,
                FpRnrProtocolManageDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<FpRnrProtocolManageDTO>> queryByList(FpRnrProtocolManageDTO bean) {
		 return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrProtocolManage/queryByList", bean,
                FpRnrProtocolManageDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(FpRnrProtocolManageDTO bean) {
	   return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrProtocolManage/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(FpRnrProtocolManageDTO bean) {
		return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrProtocolManage/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(FpRnrProtocolManageDTO bean) {
		return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrProtocolManage/deleteById", bean, Response.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<FpRnrProtocolManageDTO>> queryByOrgId(FpRnrProtocolManageDTO bean) {
        return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrProtocolManage/queryByOrgId", bean,
                FpRnrProtocolManageDTO.class);
    }
}
