package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.ApiCarInfoDTO;
import com.cusc.nirvana.user.rnr.fp.dto.ApiCarMessageDTO;
import com.cusc.nirvana.user.rnr.fp.dto.CarInfoBindingDTO;
import com.cusc.nirvana.user.rnr.fp.dto.FpCarInfoDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.ApiAuthStateDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 车辆信息表(FpCarInfo) client 
 *
 * @author yuy336
 * @since 2022-06-28 19:43:47
 */
@Component
public class FpCarInfoClient {
   
    @Autowired
    RestTemplate restTemplateRnrFp;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<FpCarInfoDTO>> queryByPage(FpCarInfoDTO bean) {
		return RnrFpRestTemplateUtils.postForResponsePageResult(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpCarInfo/queryByPage", bean, FpCarInfoDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<FpCarInfoDTO> getByUuid(FpCarInfoDTO bean) {
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL +  "/fpCarInfo/getByUuid",
               bean,
                FpCarInfoDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<FpCarInfoDTO>> queryByList(FpCarInfoDTO bean) {
		 return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpCarInfo/queryByList", bean,
                FpCarInfoDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(FpCarInfoDTO bean) {
	   return RnrFpRestTemplateUtils.postForObject(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpCarInfo/add", bean, Response.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response addBatch(CarInfoBindingDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpCarInfo/addBatch", bean, Response.class);
    }
    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response addBatchList(ApiCarInfoDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpCarInfo/addBatchList", bean, Response.class);
    }
    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(FpCarInfoDTO bean) {
		return RnrFpRestTemplateUtils.postForObject(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpCarInfo/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(FpCarInfoDTO bean) {
		return RnrFpRestTemplateUtils.postForObject(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpCarInfo/deleteById", bean, Response.class);
    }

}
