package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @author yubo
 * @since 2022-06-16 18:05
 */
@Service
public class T1DataUploadClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * 上报数据到T1
     *
     * @param mgCardNoticeDTO
     * @return
     */
    public Response uploadUserInfoAndFile(MgCardNoticeDTO mgCardNoticeDTO) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/t1/data"
                + "/uploadUserInfoAndFile", mgCardNoticeDTO, Object.class);
    }
}
