package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.SmsRequestDTO;
import com.cusc.nirvana.user.rnr.fp.dto.SmsResponseDTO;
import com.cusc.nirvana.user.rnr.fp.dto.UnbindReceiceSMSDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

/**
 * @author yubo
 * @since 2022-04-19 16:04
 */
@Service
public class SmsClient {

    @Resource
    private RestTemplate restTemplateRnrFp;

    public Response<SmsResponseDTO> sendSmsCaptcha(SmsRequestDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/check/sendSms", bean, SmsResponseDTO.class);
    }

    public Response checkSmsCaptcha(SmsRequestDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/check/checkSms", bean, Object.class);
    }

    public Response callBack(@RequestBody UnbindReceiceSMSDTO bean) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/message/callBack", bean, Object.class);
    }
}
