package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.FpUserOperationLogDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 用户操作日志(FpUserOperationLog) client 
 *
 * @author yuy336
 * @since 2022-06-20 09:38:25
 */
@Component
public class FpUserOperationLogClient {
   
    @Autowired
    RestTemplate restTemplateUser;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<FpUserOperationLogDTO>> queryByPage(FpUserOperationLogDTO bean) {
		return RnrFpRestTemplateUtils.postForResponsePageResult(restTemplateUser, UserRnrFpConstant.USER_RNR_FP_URL + "/fpUserOperationLog/queryByPage", bean, FpUserOperationLogDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<FpUserOperationLogDTO> getByUuid(FpUserOperationLogDTO bean) {
		return RnrFpRestTemplateUtils.postForResponse(restTemplateUser, UserRnrFpConstant.USER_RNR_FP_URL +  "/fpUserOperationLog/getByUuid",
               bean,
                FpUserOperationLogDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<FpUserOperationLogDTO>> queryByList(FpUserOperationLogDTO bean) {
		 return RnrFpRestTemplateUtils.postForResponseList(restTemplateUser, UserRnrFpConstant.USER_RNR_FP_URL + "/fpUserOperationLog/queryByList", bean,
                FpUserOperationLogDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(FpUserOperationLogDTO bean) {
	   return RnrFpRestTemplateUtils.postForObject(restTemplateUser, UserRnrFpConstant.USER_RNR_FP_URL + "/fpUserOperationLog/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(FpUserOperationLogDTO bean) {
		return RnrFpRestTemplateUtils.postForObject(restTemplateUser, UserRnrFpConstant.USER_RNR_FP_URL + "/fpUserOperationLog/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(FpUserOperationLogDTO bean) {
		return RnrFpRestTemplateUtils.postForObject(restTemplateUser, UserRnrFpConstant.USER_RNR_FP_URL + "/fpUserOperationLog/deleteById", bean, Response.class);
    }
}
