package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.FpRnrSmsInfoDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 实名业务短信信息(FpRnrSmsInfo) client 
 *
 * @author yuy336
 * @since 2022-04-19 20:38:57
 */
@Component
public class FpRnrSmsInfoClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * 分页查询
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    public Response<PageResult<FpRnrSmsInfoDTO>> queryByPage(FpRnrSmsInfoDTO bean) {
		return RnrFpRestTemplateUtils.postForResponsePageResult(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrSmsInfo/queryByPage", bean, FpRnrSmsInfoDTO.class);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<FpRnrSmsInfoDTO> getByUuid(FpRnrSmsInfoDTO bean) {
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL +  "/fpRnrSmsInfo/getByUuid",
               bean,
                FpRnrSmsInfoDTO.class);
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    public Response<List<FpRnrSmsInfoDTO>> queryByList(FpRnrSmsInfoDTO bean) {
		 return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrSmsInfo/queryByList", bean,
                FpRnrSmsInfoDTO.class);
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    public Response add(FpRnrSmsInfoDTO bean) {
	   return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrSmsInfo/add", bean, Response.class);
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    public Response update(FpRnrSmsInfoDTO bean) {
		return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrSmsInfo/update", bean, Response.class);
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    public Response<Boolean> deleteById(FpRnrSmsInfoDTO bean) {
		return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/fpRnrSmsInfo/deleteById", bean, Response.class);
    }
}
