package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.H5ValidationOCRReqDTO;
import com.cusc.nirvana.user.rnr.fp.dto.LiveLoginReqDTO;
import com.cusc.nirvana.user.rnr.fp.dto.LiveLoginRespDTO;
import com.cusc.nirvana.user.rnr.fp.dto.LivenessCodeRequestDTO;
import com.cusc.nirvana.user.rnr.fp.dto.LivenessCodeResponseDTO;
import com.cusc.nirvana.user.rnr.fp.dto.LivenessResultDTO;
import com.cusc.nirvana.user.rnr.fp.dto.PersonH5CallBackRequestDTO;
import com.cusc.nirvana.user.rnr.fp.dto.RnrResponseDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

/**
 * @author yubo
 * @since 2022-04-20 11:21
 */
@Service
public class FpRnrClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    public Response<LivenessCodeResponseDTO> getLivenessCode(LivenessCodeRequestDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/getLivenessCode",
                dto, LivenessCodeResponseDTO.class);
    }

    public Response personRnr(String serialNumber, String requestId, RnrRelationDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/personRnr/" + serialNumber + "/" + requestId,
                dto, Object.class);
    }

    public Response personSecondHandRnr(String serialNumber, String requestId, RnrRelationDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/personSecondHandRnr/" + serialNumber + "/" + requestId,
                dto, Object.class);
    }


    public Response personRnrH5(@PathVariable("serialNumber") String serialNumber,
                                @RequestBody RnrRelationDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/personRnrH5/" + serialNumber, dto, Object.class);
    }


    public Response<Integer> personH5CallBack(@RequestBody PersonH5CallBackRequestDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/personRnrH5CallBack", dto, Integer.class);
    }

    public Response<RnrResponseDTO> personalInfoOnlyRnr(@RequestBody RnrRelationDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/personalInfoOnlyRnr", dto, RnrResponseDTO.class);
    }

    public Response<String> getRnrLivenessType(String tenantNo) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/getRnrLivenessType/" + tenantNo, null, String.class);
    }

    public Response<LiveLoginRespDTO> h5LiveLoginUrl(@RequestBody LiveLoginReqDTO dto){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/h5LiveLoginUrl" , dto, LiveLoginRespDTO.class);
    }

    public Response<LivenessResultDTO> h5LivenessResult(@RequestBody LiveLoginReqDTO dto){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/h5LivenessResult" , dto, LivenessResultDTO.class);
    }

    public Response<RnrResponseDTO> h5ValidationOCR(@RequestBody H5ValidationOCRReqDTO dto){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/h5ValidationOCR" , dto, RnrResponseDTO.class);
    }

    public Response updateRnrInValid(@RequestBody RnrOrderDTO dto){
        return RnrFpRestTemplateUtils.postForObject(restTemplateRnrFp,
                UserRnrFpConstant.USER_RNR_FP_URL + "/rnr/updateRnrInValid" , dto, Response.class);
    }
}
