package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.EnterpriseChangeRnrPersonDTO;
import com.cusc.nirvana.user.rnr.fp.dto.EnterpriseH5CallBackRequestDTO;
import com.cusc.nirvana.user.rnr.fp.dto.EnterpriseRnrPersonNameReqDTO;
import com.cusc.nirvana.user.rnr.fp.dto.EnterpriseRnrPersonNameResponseDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 企业实名 client
 */
@Component
public class EnterpriseRnrClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;


    /**
     * 企业实名
     *
     * @param
     */
    public Response enterpriseRnr(RnrRelationDTO dto, String requestId) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/enterpris/enterpriseRnr" + "/" + requestId, dto, Object.class);
    }

    /**
     * 企业实名认证-后续，直接通过
     *
     * @param
     */
    public Response enterpriseRnrFollowUp(RnrRelationDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/enterpris/enterpriseRnrFollowUp", dto, Object.class);
    }

    public Response<List<EnterpriseRnrPersonNameResponseDTO>> queryEnterpriseRnrPersonName(EnterpriseRnrPersonNameReqDTO dto) {
        return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/enterpris/queryEnterpriseRnrPersonName", dto, EnterpriseRnrPersonNameResponseDTO.class);

    }

    public Response changeEnterpriseRnrPerson(String serialNumber, String requestId, EnterpriseChangeRnrPersonDTO dto) {
        return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/enterpris/changeEnterpriseRnrPerson/" + serialNumber + "/" + requestId, dto, Response.class);
    }

    public Response changeEnterpriseRnrPersonNoSms(String serialNumber, String requestId, EnterpriseChangeRnrPersonDTO dto) {
        return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/enterpris/changeEnterpriseRnrPersonNoSms/" + serialNumber + "/" + requestId, dto, Response.class);
    }


	public Response submitH5(@RequestBody RnrRelationDTO rnrRelationDTO){
		return restTemplateRnrFp.postForObject(UserRnrFpConstant.USER_RNR_FP_URL + "/enterpris/submitH5", rnrRelationDTO, Response.class);
	}

	public Response<Integer> enterpriseRnrH5CallBack(@RequestBody EnterpriseH5CallBackRequestDTO dto) {
		return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL + "/enterpris/enterpriseRnrH5CallBack", dto, Integer.class);
	}

    public Response enterpriseUnBind(@RequestBody RnrRelationDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL + "/enterpris/unBind", dto, Response.class);
    }
}
