package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.FpDirectTboxChangeDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 换绑 client
 */
@Component
public class ChangeTboxClient {

    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    /**
     * 换卡
     *
     * @param
     */
    public Response<Boolean> changeTbox(RnrRelationDTO relationDTO) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/change/tbox/submit",
                relationDTO,
                Boolean.class);
    }

    /**
     * 换卡
     *
     * @param
     */
    public Response directChangeBox(FpDirectTboxChangeDTO tboxChangeDTO) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/change/tbox/directChangeBox",
                tboxChangeDTO,
                Object.class);
    }

    /**
     * 解绑
     *
     * @param
     */
    public Response unbindCards(List<MgRnrCardInfoDTO> cardInfoDTOList) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/change/tbox/unbindCards",
                cardInfoDTOList,
                Object.class);
    }

    /**
     * 换卡
     *
     * @param
     */
    public Response bindCards(List<MgRnrCardInfoDTO> cardInfoDTOList) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/change/tbox/bindCards",
                cardInfoDTOList,
                Object.class);
    }

    /**
     * 状态
     *
     * @param
     */
    public Response<Boolean> checkStatus(List<String> iccids) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/change/tbox/checkStatus",
                iccids,
                Boolean.class);
    }


}
