package com.cusc.nirvana.user.rnr.fp.client;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.FpRnrSmsInfoDTO;
import com.cusc.nirvana.user.rnr.fp.dto.FpSendMessageDTO;
import com.cusc.nirvana.user.rnr.fp.dto.FpVehicleCardRnrDTO;
import com.cusc.nirvana.user.rnr.fp.dto.UnbindReceiceSMSDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 卡解绑 client
 *
 */
@Component
@Slf4j
public class CardUnBindClient {
    @Autowired
    @Qualifier("restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;


    /**
     * 车主 卡解绑
     * @param
     */
    public Response<Boolean> cardOwnerUnBind(RnrRelationDTO relationDTO) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL+  "/card/Unbind/ownerUnbind",
                relationDTO,
                Boolean.class);
    }

    /**
     * 根据 vin 获取cardlist
     * @param
     */
    public Response<List<MgRnrCardInfoDTO>> getCardList( FpVehicleCardRnrDTO dto) {
        return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL+  "/card/Unbind/getCardList",
                dto,
                MgRnrCardInfoDTO.class);
    }

    /**
     * 发送短信
     */
    public Response<FpRnrSmsInfoDTO> sendSms(FpSendMessageDTO sendMessageDTO){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL+"/card/Unbind/sendMessage",sendMessageDTO,FpRnrSmsInfoDTO.class);
    }

    /**
     * 短信回调
     */
    public Response<FpRnrSmsInfoDTO> receiveMessage(UnbindReceiceSMSDTO receiceSMSDTO){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL+"/card/Unbind/receiverMessage",receiceSMSDTO,FpRnrSmsInfoDTO.class);
    }


    /**
     * 轮询查询短信状态
     */
    public Response<FpRnrSmsInfoDTO> getMessageStatus(FpRnrSmsInfoDTO bean){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL+"/card/Unbind/getMessageStatus",bean,FpRnrSmsInfoDTO.class);
    }
    /**
     * 获取车主人信息
     * @return
     */
    public Response<MgRnrInfoDTO> getRnrInfo(FpVehicleCardRnrDTO dto) {
        log.info("获取车主人信息: {}", JSON.toJSONString(dto));
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL+  "/card/Unbind/getUserInfo",
                dto,
                MgRnrInfoDTO.class);
    }

    /**
     * 轮询工单状态
     */
    public Response<RnrOrderDTO> getOrderStatus(RnrOrderDTO bean){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL+"/card/Unbind/getOrderStatus",bean,RnrOrderDTO.class);
    }

    /**
     * 插入工单
     */
    public Response<RnrOrderDTO> insertOrder(RnrOrderDTO bean){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL+"/card/Unbind/insertOrder",bean,RnrOrderDTO.class);
    }

    /**
     * 更新工单
     */
    public Response<RnrOrderDTO> updateOrder(RnrOrderDTO bean){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL+"/card/Unbind/updateOrder",bean,RnrOrderDTO.class);
    }

    /**
     * 校验短信超时
     */
    public Response checkMessageOutTime(RnrOrderDTO bean){
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp,UserRnrFpConstant.USER_RNR_FP_URL+"/card/Unbind/checkMSMtime",bean,Object.class);
    }

}
