/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.fp.dto;

import com.cusc.nirvana.user.rnr.fp.dto.VinCardCheckMessageFailDTO;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class VinCardCheckMessageResultDTO {
    private Boolean checkResult;
    private List<CardErrorMessageDetailDTO> errorMessageList;

    public void build(List<VinCardCheckMessageFailDTO> failDTOList) {
        if (CollectionUtils.isEmpty(failDTOList)) {
            this.setCheckResult(true);
            this.setErrorMessageList(Collections.emptyList());
        } else {
            this.setCheckResult(false);
            Map<String, List<VinCardCheckMessageFailDTO>> iccidMap = failDTOList.stream().collect(Collectors.groupingBy(VinCardCheckMessageFailDTO::getIccid));
            List<CardErrorMessageDetailDTO> detailDTOList = iccidMap.entrySet().stream().map(entry -> {
                CardErrorMessageDetailDTO detailDTO = new CardErrorMessageDetailDTO();
                detailDTO.setIccid((String)entry.getKey());
                List<String> errorMsgList = ((List)entry.getValue()).stream().map(VinCardCheckMessageFailDTO::getErrorMsg).collect(Collectors.toList());
                detailDTO.setErrorMsg(errorMsgList);
                return detailDTO;
            }).collect(Collectors.toList());
            this.setErrorMessageList(detailDTOList);
        }
    }

    public void merge(VinCardCheckMessageResultDTO merge) {
        this.setCheckResult(this.getCheckResult() != false && merge.getCheckResult() != false);
        this.getErrorMessageList().addAll(merge.getErrorMessageList());
    }

    public Boolean getCheckResult() {
        return this.checkResult;
    }

    public List<CardErrorMessageDetailDTO> getErrorMessageList() {
        return this.errorMessageList;
    }

    public void setCheckResult(Boolean checkResult) {
        this.checkResult = checkResult;
    }

    public void setErrorMessageList(List<CardErrorMessageDetailDTO> errorMessageList) {
        this.errorMessageList = errorMessageList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VinCardCheckMessageResultDTO)) {
            return false;
        }
        VinCardCheckMessageResultDTO other = (VinCardCheckMessageResultDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$checkResult = this.getCheckResult();
        Boolean other$checkResult = other.getCheckResult();
        if (this$checkResult == null ? other$checkResult != null : !((Object)this$checkResult).equals(other$checkResult)) {
            return false;
        }
        List<CardErrorMessageDetailDTO> this$errorMessageList = this.getErrorMessageList();
        List<CardErrorMessageDetailDTO> other$errorMessageList = other.getErrorMessageList();
        return !(this$errorMessageList == null ? other$errorMessageList != null : !((Object)this$errorMessageList).equals(other$errorMessageList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VinCardCheckMessageResultDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $checkResult = this.getCheckResult();
        result = result * 59 + ($checkResult == null ? 43 : ((Object)$checkResult).hashCode());
        List<CardErrorMessageDetailDTO> $errorMessageList = this.getErrorMessageList();
        result = result * 59 + ($errorMessageList == null ? 43 : ((Object)$errorMessageList).hashCode());
        return result;
    }

    public String toString() {
        return "VinCardCheckMessageResultDTO(checkResult=" + this.getCheckResult() + ", errorMessageList=" + this.getErrorMessageList() + ")";
    }

    public static class CardErrorMessageDetailDTO {
        private String iccid;
        private List<String> errorMsg;

        public String getIccid() {
            return this.iccid;
        }

        public List<String> getErrorMsg() {
            return this.errorMsg;
        }

        public void setIccid(String iccid) {
            this.iccid = iccid;
        }

        public void setErrorMsg(List<String> errorMsg) {
            this.errorMsg = errorMsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CardErrorMessageDetailDTO)) {
                return false;
            }
            CardErrorMessageDetailDTO other = (CardErrorMessageDetailDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$iccid = this.getIccid();
            String other$iccid = other.getIccid();
            if (this$iccid == null ? other$iccid != null : !this$iccid.equals(other$iccid)) {
                return false;
            }
            List<String> this$errorMsg = this.getErrorMsg();
            List<String> other$errorMsg = other.getErrorMsg();
            return !(this$errorMsg == null ? other$errorMsg != null : !((Object)this$errorMsg).equals(other$errorMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CardErrorMessageDetailDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $iccid = this.getIccid();
            result = result * 59 + ($iccid == null ? 43 : $iccid.hashCode());
            List<String> $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : ((Object)$errorMsg).hashCode());
            return result;
        }

        public String toString() {
            return "VinCardCheckMessageResultDTO.CardErrorMessageDetailDTO(iccid=" + this.getIccid() + ", errorMsg=" + this.getErrorMsg() + ")";
        }
    }
}

