/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.web.handler;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.web.exception.AppGlobalException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Order(value=1)
@ControllerAdvice
public class AppGlobalExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(AppGlobalExceptionHandler.class);

    @ExceptionHandler(value={IllegalArgumentException.class, MethodArgumentNotValidException.class, AppGlobalException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Response methodArgumentNotValidExceptionHandle(Exception ex) {
        String message = "";
        if (ex instanceof IllegalArgumentException) {
            this.logger.error("IllegalArgumentException:", (Throwable)ex);
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)ex;
            message = "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5";
        } else if (ex instanceof MethodArgumentNotValidException) {
            this.logger.error("MethodArgumentNotValidException:", (Throwable)ex);
            MethodArgumentNotValidException methodArgumentNotValidException = (MethodArgumentNotValidException)ex;
            message = "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5";
        } else {
            if (ex instanceof AppGlobalException) {
                this.logger.error("AppGlobalException:", (Throwable)ex);
                AppGlobalException appGlobalException = (AppGlobalException)ex;
                Response response = appGlobalException.getRes();
                if (response.getData() instanceof Throwable) {
                    response.setData(null);
                }
                return response;
            }
            message = "\u672a\u77e5\u7cfb\u7edf\u5f02\u5e38200";
        }
        return Response.createError((String)message);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Response validExceptionHandle(Exception ex) {
        String responseMsg;
        String message;
        if (ex instanceof BindException) {
            BindException bingException = (BindException)ex;
            message = ((ObjectError)bingException.getAllErrors().get(0)).getDefaultMessage();
            responseMsg = "\u8bf7\u6c42\u8def\u5f84\u6216\u8005\u53c2\u6570\u4e0d\u5408\u6cd5";
        } else if (ex instanceof HttpMessageNotReadableException) {
            HttpMessageNotReadableException notReadableException = (HttpMessageNotReadableException)ex;
            message = notReadableException.getMessage();
            responseMsg = "\u8bf7\u6c42\u8def\u5f84\u6216\u8005\u53c2\u6570\u4e0d\u5408\u6cd5";
        } else if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException validationException = (ConstraintViolationException)ex;
            Set violationErrors = validationException.getConstraintViolations();
            ConstraintViolation error = (ConstraintViolation)violationErrors.iterator().next();
            message = error.getMessage();
            responseMsg = "\u8bf7\u6c42\u8def\u5f84\u6216\u8005\u53c2\u6570\u4e0d\u5408\u6cd5";
        } else if (ex instanceof HttpRequestMethodNotSupportedException) {
            HttpRequestMethodNotSupportedException methodNotSupportedException = (HttpRequestMethodNotSupportedException)ex;
            message = methodNotSupportedException.getMessage();
            responseMsg = "\u8bf7\u6c42\u8def\u5f84\u6216\u8005\u53c2\u6570\u4e0d\u5408\u6cd5";
        } else {
            responseMsg = message = "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01";
        }
        this.logger.error("{}:", (Object)message, (Object)ex);
        return Response.createError((String)responseMsg);
    }
}

