package com.cusc.nirvana.web.converter;

import com.cusc.nirvana.web.interceptor.AppGlobalHandlerInterceptor;
import org.springframework.core.annotation.Order;
import org.springframework.http.CacheControl;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.WebContentInterceptor;

import java.util.List;

/**
 * @author jeff.chen
 * @file AppGlobalWebMvcConfigurerAdapter
 * @E-mail chenjf159@chinaunicom.cn
 */
@Order(-10)
@Component
public class AppGlobalWebMvcConfigurerAdapter implements WebMvcConfigurer, AppHttpMessageConverter {

    /**
     * 拦截器配置
     *
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        WebContentInterceptor webContentInterceptor = new WebContentInterceptor();
        CacheControl nocache = CacheControl.noCache();
        webContentInterceptor.addCacheMapping(nocache, "/**");
        registry.addInterceptor(webContentInterceptor);
        //添加拦截器,排除swagger拦截
        registry.addInterceptor(new AppGlobalHandlerInterceptor()).excludePathPatterns("/swagger*", "/webjars/**", "/v2/api-docs");
        WebMvcConfigurer.super.addInterceptors(registry);
    }

    /**
     * url 参数配置
     *
     * @param configurer
     */
    @Override
    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseSuffixPatternMatch(false);
    }

    @Override
    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        // 默认 FastJson UTC时间格式
        setAppHttpMessageConverter(converters);
    }

}
