package com.cusc.nirvana.web.exception;

import com.cusc.nirvana.common.result.Response;

/**
 * @author jeff.chen
 * @des: 全局异常
 * @E-mail chenjf159@chinaunicom.cn
 */
public class AppGlobalException extends RuntimeException {

    private Response res;

    public AppGlobalException(String msg) {
        super(msg);
        res = Response.createError(msg);
    }

    public AppGlobalException(Integer code, String msg) {
        super(msg);
        res = Response.createError(msg, code);
    }

    public AppGlobalException(String msg, Throwable cause) {
        super(msg, cause);
        res = Response.createError(msg, 500, cause);
    }

    public AppGlobalException(Integer code, String msg, Throwable cause) {
        super(msg, cause);
        res = Response.createError(msg, code, cause);
    }

    public Response getRes() {
        return res;
    }

}
