package com.cusc.nirvana.web.converter;

import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;

import java.util.List;

/**
 * @author jeff.chen
 * @file AppHttpMessageConverter
 * @E-mail chenjf159@chinaunicom.cn
 */
public interface AppHttpMessageConverter {

    /**
     * 设置序列化转换器
     *
     * @param converters
     * @return
     */
    default List<HttpMessageConverter<?>> setAppHttpMessageConverter(List<HttpMessageConverter<?>> converters) {
        // MappingJackson2HttpMessageConverter
        // MappingJackson2SmileHttpMessageConverter
        // MappingJackson2CborHttpMessageConverter
        // FastJsonHttpMessageConverter
        converters.removeIf(converter ->
                converter instanceof MappingJackson2HttpMessageConverter
                        || converter instanceof MappingJackson2SmileHttpMessageConverter
                        || converter instanceof MappingJackson2CborHttpMessageConverter
                        || converter instanceof FastJsonHttpMessageConverter);

        if (fastJsonSerializationByTimestamp()) {
            converters.add(fastJsonHttpMessageConverterTimestamp());
        } else {
            converters.add(fastJsonHttpMessageConverterUTC());
        }

        return converters;
    }

    /**
     * 使用fastJson序列化时，是否使用时间戳格式
     *
     * @return
     */
    default boolean fastJsonSerializationByTimestamp() {
        return false;
    }

    /**
     * UTC时间格式
     *
     * @return
     */
    static HttpMessageConverter fastJsonHttpMessageConverterUTC() {
        return AppHttpMessageConverterProvider.fastJsonHttpMessageConverterUTC();
    }

    /**
     * 时间戳格式
     *
     * @return
     */
    static HttpMessageConverter fastJsonHttpMessageConverterTimestamp() {
        return AppHttpMessageConverterProvider.fastJsonHttpMessageConverterTimestamp();
    }

}
