/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.spring.boot;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextHelper
implements ApplicationContextAware {
    private static transient ApplicationContext SPRING_CONTEXT;

    private SpringContextHelper() {
    }

    public static ApplicationContext getSpringContext() {
        return SPRING_CONTEXT;
    }

    public static void setSpringContext(ApplicationContext springContext) {
        SPRING_CONTEXT = springContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return (T)SPRING_CONTEXT.getBean(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return SPRING_CONTEXT.getBeansOfType(clazz);
    }

    public static <T> T getBean(String name) {
        return (T)SPRING_CONTEXT.getBean(name);
    }

    public static boolean preparedSpringContext() {
        return SPRING_CONTEXT != null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextHelper.setSpringContext(applicationContext);
    }
}

