package com.cusc.nirvana.spring.boot;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author jeff.chen
 * @file SpringContextHelper
 * @E-mail chenjf159@chinaunicom.cn
 */
@Component
public class SpringContextHelper implements ApplicationContextAware {

    private SpringContextHelper() {
    }

    private static transient ApplicationContext SPRING_CONTEXT;

    public static ApplicationContext getSpringContext() {
        return SPRING_CONTEXT;
    }

    public static void setSpringContext(ApplicationContext springContext) {
        SpringContextHelper.SPRING_CONTEXT = springContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return SPRING_CONTEXT.getBean(clazz);
        } catch (Exception ex) {
            // pass
        }

        return null;
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return SPRING_CONTEXT.getBeansOfType(clazz);
    }

    @SuppressWarnings("unchecked")
    public static <T> T getBean(String name) {
        return (T) SPRING_CONTEXT.getBean(name);
    }

    /**
     * 是否已准备 SpringContext
     *
     * @return true: prepared
     */
    public static boolean preparedSpringContext() {
        return SPRING_CONTEXT != null;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        setSpringContext(applicationContext);
    }

}
