package com.cusc.nirvana.spring.actuator.endpoint;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author jeff.chen
 * @file CuscDependenciesEndpointAutoConfiguration
 * @date 2021/10/19
 * @E-mail chenjf159@chinaunicom.cn
 */
@Configuration
@ConditionalOnEnabledEndpoint(endpoint = CuscDependenciesEndpoint.class)
public class CuscDependenciesEndpointAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public CuscDependenciesEndpoint cuscDependenciesEndpoint(ConfigurableApplicationContext applicationContext) {
        return new CuscDependenciesEndpoint(applicationContext);
    }

}
