package com.cusc.nirvana.spring.actuator.endpoint;

import com.cusc.nirvana.spring.actuator.ActuatorEnvHelper;
import com.cusc.nirvana.spring.actuator.Wapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ConfigurableApplicationContext;

/**
 * @author jeff.chen
 * @file CuscDependenciesEndpoint
 * @date 2021/10/19
 * @E-mail chenjf159@chinaunicom.cn
 */
@Endpoint(id = "cusc-dependencies")
public class CuscDependenciesEndpoint {

    private final ConfigurableApplicationContext context;

    @Autowired
    ActuatorEnvHelper actuatorEnvHelper;

    public CuscDependenciesEndpoint(ConfigurableApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @ReadOperation
    public Wapper dependencies() {
        return actuatorEnvHelper.parseDependencies();
    }

}
