package com.cusc.nirvana.spring.actuator;

import com.cusc.nirvana.spring.tools.StringUtils;
import lombok.Getter;
import lombok.Setter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.web.mappings.HandlerMethodDescription;
import org.springframework.boot.actuate.web.mappings.MappingsEndpoint;
import org.springframework.boot.actuate.web.mappings.servlet.DispatcherServletMappingDescription;
import org.springframework.boot.actuate.web.mappings.servlet.DispatcherServletMappingDetails;
import org.springframework.boot.actuate.web.mappings.servlet.RequestMappingConditionsDescription;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author jeff.chen
 * @file ActuatorMappingsHelper
 * @date 2021/10/18
 * @E-mail chenjf159@chinaunicom.cn
 */
@Component
public class ActuatorMappingsHelper {

    static final Logger LOGGER = LoggerFactory.getLogger(ActuatorMappingsHelper.class);

    @Resource
    MappingsEndpoint mappingsEndpoint;

    @Autowired
    ActuatorEnvHelper actuatorEnvHelper;

    Wapper data = null;

    Set<MappingItem> OTHER = new HashSet<>(256);

    Set<MappingItem> CU_SC = new HashSet<>(256);

    public Wapper parseMappings() {
        if (null != data) {
            return data;
        }

        try {
            MappingsEndpoint.ApplicationMappings applicationMappings = mappingsEndpoint.mappings();

            Map<String, MappingsEndpoint.ContextMappings> map = applicationMappings.getContexts();

            for (String key : map.keySet()) {
                MappingsEndpoint.ContextMappings contextMappings = map.get(key);
                String parentId = contextMappings.getParentId();

                Map<String, Object> map1 = contextMappings.getMappings();
                if (map1.isEmpty()) {
                    continue;
                }

                Map<String, Object> map2 = (Map<String, Object>) map1.get("dispatcherServlets");
                if (map2.isEmpty()) {
                    continue;
                }

                List<DispatcherServletMappingDescription> list = (List) map2.get("dispatcherServlet");
                if (list.isEmpty()) {
                    continue;
                }

                for (DispatcherServletMappingDescription item : list) {
                    DispatcherServletMappingDetails details = item.getDetails();
                    if (Objects.isNull(details)) {
                        continue;
                    }

                    HandlerMethodDescription handlerMethod = details.getHandlerMethod();
                    if (Objects.isNull(handlerMethod)) {
                        continue;
                    }

                    RequestMappingConditionsDescription requestMapping = details.getRequestMappingConditions();
                    if (Objects.isNull(requestMapping)) {
                        continue;
                    }

                    MappingItem newItem = new MappingItem((null == parentId) ? key : parentId,
                            handlerMethod.getClassName(),
                            handlerMethod.getName(),
                            StringUtils.toString(requestMapping.getMethods()),
                            StringUtils.toString(requestMapping.getPatterns()));

                    if (handlerMethod.getClassName().indexOf("cusc") < 0) {
                        OTHER.add(newItem);
                    } else {
                        CU_SC.add(newItem);
                    }
                }
            }

            data = Wapper.wapper(CU_SC, OTHER);
        } catch (Exception ex) {
            LOGGER.error("不影响业务正常运行@ActuatorMappingsHelper", ex);
            data = null;
        }

        return data;
    }

    @Getter
    @Setter
    class MappingItem {
        String parentId;
        String className;
        String method;
        String methods;
        String patterns;

        public MappingItem() {
        }

        public MappingItem(String parentId, String className, String method, String methods, String patterns) {
            this.parentId = parentId;
            this.className = className;
            this.method = method;
            this.methods = methods;
            this.patterns = patterns;
        }

    }

}
