/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.spring.actuator;

import com.cusc.nirvana.spring.actuator.ActuatorEnvHelper;
import com.cusc.nirvana.spring.actuator.Wapper;
import com.cusc.nirvana.spring.tools.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.web.mappings.HandlerMethodDescription;
import org.springframework.boot.actuate.web.mappings.MappingsEndpoint;
import org.springframework.boot.actuate.web.mappings.servlet.DispatcherServletMappingDescription;
import org.springframework.boot.actuate.web.mappings.servlet.DispatcherServletMappingDetails;
import org.springframework.boot.actuate.web.mappings.servlet.RequestMappingConditionsDescription;
import org.springframework.stereotype.Component;

@Component
public class ActuatorMappingsHelper {
    static final Logger LOGGER = LoggerFactory.getLogger(ActuatorMappingsHelper.class);
    @Resource
    MappingsEndpoint mappingsEndpoint;
    @Autowired
    ActuatorEnvHelper actuatorEnvHelper;
    Wapper data = null;
    Set<MappingItem> OTHER = new HashSet<MappingItem>(256);
    Set<MappingItem> CU_SC = new HashSet<MappingItem>(256);

    public Wapper parseMappings() {
        if (null != this.data) {
            return this.data;
        }
        try {
            MappingsEndpoint.ApplicationMappings applicationMappings = this.mappingsEndpoint.mappings();
            Map map = applicationMappings.getContexts();
            for (String key : map.keySet()) {
                List list;
                Map map2;
                MappingsEndpoint.ContextMappings contextMappings = (MappingsEndpoint.ContextMappings)map.get(key);
                String parentId = contextMappings.getParentId();
                Map map1 = contextMappings.getMappings();
                if (map1.isEmpty() || (map2 = (Map)map1.get("dispatcherServlets")).isEmpty() || (list = (List)map2.get("dispatcherServlet")).isEmpty()) continue;
                for (DispatcherServletMappingDescription item : list) {
                    RequestMappingConditionsDescription requestMapping;
                    HandlerMethodDescription handlerMethod;
                    DispatcherServletMappingDetails details = item.getDetails();
                    if (Objects.isNull(details) || Objects.isNull(handlerMethod = details.getHandlerMethod()) || Objects.isNull(requestMapping = details.getRequestMappingConditions())) continue;
                    MappingItem newItem = new MappingItem(null == parentId ? key : parentId, handlerMethod.getClassName(), handlerMethod.getName(), StringUtils.toString(requestMapping.getMethods()), StringUtils.toString(requestMapping.getPatterns()));
                    if (handlerMethod.getClassName().indexOf("cusc") < 0) {
                        this.OTHER.add(newItem);
                        continue;
                    }
                    this.CU_SC.add(newItem);
                }
            }
            this.data = Wapper.wapper(this.CU_SC, this.OTHER);
        }
        catch (Exception ex) {
            LOGGER.error("\u4e0d\u5f71\u54cd\u4e1a\u52a1\u6b63\u5e38\u8fd0\u884c@ActuatorMappingsHelper", (Throwable)ex);
            this.data = null;
        }
        return this.data;
    }

    class MappingItem {
        String parentId;
        String className;
        String method;
        String methods;
        String patterns;

        public MappingItem() {
        }

        public MappingItem(String parentId, String className, String method, String methods, String patterns) {
            this.parentId = parentId;
            this.className = className;
            this.method = method;
            this.methods = methods;
            this.patterns = patterns;
        }

        public String getParentId() {
            return this.parentId;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethod() {
            return this.method;
        }

        public String getMethods() {
            return this.methods;
        }

        public String getPatterns() {
            return this.patterns;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setMethods(String methods) {
            this.methods = methods;
        }

        public void setPatterns(String patterns) {
            this.patterns = patterns;
        }
    }
}

