/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.spring.actuator;

import com.cusc.nirvana.spring.actuator.Wapper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;
import org.springframework.stereotype.Component;

@Component
public class ActuatorEnvHelper {
    static final Logger LOGGER = LoggerFactory.getLogger(ActuatorEnvHelper.class);
    @Resource
    EnvironmentEndpoint environmentEndpoint;
    Wapper data = null;
    Set<DependencyItem> OTHER = new HashSet<DependencyItem>(256);
    Set<DependencyItem> CU_SC = new HashSet<DependencyItem>(256);

    public Wapper parseDependencies() {
        if (null != this.data) {
            return this.data;
        }
        try {
            EnvironmentEndpoint.EnvironmentEntryDescriptor environmentEntryDescriptor = this.environmentEndpoint.environmentEntry("java.class.path");
            EnvironmentEndpoint.PropertySummaryDescriptor property = environmentEntryDescriptor.getProperty();
            if (null != property && null != property.getValue() && property.getValue() instanceof String) {
                String[] items;
                String value = String.valueOf(property.getValue());
                for (String item : items = value.split(";")) {
                    String name = item.substring(item.lastIndexOf("\\") + 1);
                    DependencyItem dependency = new DependencyItem(name, item);
                    if (item.contains("cusc")) {
                        this.CU_SC.add(dependency);
                        continue;
                    }
                    this.OTHER.add(dependency);
                }
            }
            this.data = Wapper.wapper(this.CU_SC, this.OTHER);
        }
        catch (Exception ex) {
            LOGGER.error("\u4e0d\u5f71\u54cd\u4e1a\u52a1\u6b63\u5e38\u8fd0\u884c@ActuatorEnvHelper", (Throwable)ex);
            this.data = null;
        }
        return this.data;
    }

    class DependencyItem {
        String name;
        String path;

        public DependencyItem() {
        }

        public DependencyItem(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

