package com.cusc.nirvana.spring.boot;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * @author jeff.chen
 * @file SpringEnvConfigHelper
 * @E-mail chenjf159@chinaunicom.cn
 */
public class SpringEnvConfigHelper implements EnvironmentPostProcessor {

    private static transient ConfigurableEnvironment configurableEnvironment;

    /**
     * EnvironmentPostProcessor
     *
     * @param environment
     * @param application
     */
    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        configurableEnvironment = environment;
    }

    public static ConfigurableEnvironment getConfigurableEnvironment() {
        return configurableEnvironment;
    }

    public static void setConfigurableEnvironment(ConfigurableEnvironment configurableEnvironment) {
        SpringEnvConfigHelper.configurableEnvironment = configurableEnvironment;
    }

    public static String get(String key) {
        if (null == configurableEnvironment) {
            return null;
        }

        return configurableEnvironment.getProperty(key);
    }

}
