package com.cusc.nirvana.spring.actuator.endpoint;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author jeff.chen
 * @file CuscMappingsEndpointAutoConfiguration
 * @date 2021/10/19
 * @E-mail chenjf159@chinaunicom.cn
 */
@Configuration
@ConditionalOnEnabledEndpoint(endpoint = CuscMappingsEndpoint.class)
public class CuscMappingsEndpointAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public CuscMappingsEndpoint cuscMappingsEndpoint(ConfigurableApplicationContext applicationContext) {
        return new CuscMappingsEndpoint(applicationContext);
    }

}
