package com.cusc.nirvana.spring.actuator.endpoint;

import com.cusc.nirvana.spring.actuator.ActuatorMappingsHelper;
import com.cusc.nirvana.spring.actuator.Wapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ConfigurableApplicationContext;

/**
 * @author jeff.chen
 * @file CuscMappingsEndpoint
 * @date 2021/10/19
 * @E-mail chenjf159@chinaunicom.cn
 */
@Endpoint(id = "cusc-mappings")
public class CuscMappingsEndpoint {

    private final ConfigurableApplicationContext context;

    @Autowired
    ActuatorMappingsHelper actuatorMappingsHelper;

    public CuscMappingsEndpoint(ConfigurableApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @ReadOperation
    public Wapper mappings() {
        return actuatorMappingsHelper.parseMappings();
    }

}
