package com.cusc.nirvana.spring.actuator;

import com.cusc.nirvana.common.uid.UtilTools;
import com.cusc.nirvana.spring.boot.SpringEnvConfigHelper;
import lombok.Getter;
import lombok.Setter;

/**
 * @author jeff.chen
 * @file Wapper
 * @date 2021/10/19
 * @E-mail chenjf159@chinaunicom.cn
 */
@Getter
@Setter
public class Wapper {

    Object other;

    Object cusc;

    String applicationName;

    String ip;

    int port;

    String contextPath;

    public static Wapper wapper(Object cusc, Object other) {
        Wapper wapper = new Wapper();

        wapper.cusc = cusc;
        wapper.other = other;

        wapper.applicationName = SpringEnvConfigHelper.get("spring.application.name");
        wapper.ip = UtilTools.getHostAddress();
        wapper.port = Integer.valueOf(SpringEnvConfigHelper.get("server.port"));
        wapper.contextPath = SpringEnvConfigHelper.get("server.servlet.context-path");

        return wapper;
    }

    private Wapper() {
    }

}
