package com.cusc.nirvana.spring.actuator;

import lombok.Getter;
import lombok.Setter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author jeff.chen
 * @file ActuatorEnvHelper
 * @date 2021/10/18
 * @E-mail chenjf159@chinaunicom.cn
 */
@Component
public class ActuatorEnvHelper {

    static final Logger LOGGER = LoggerFactory.getLogger(ActuatorEnvHelper.class);

    @Resource
    EnvironmentEndpoint environmentEndpoint;

    Wapper data = null;

    Set<DependencyItem> OTHER = new HashSet<>(256);

    Set<DependencyItem> CU_SC = new HashSet<>(256);

    public Wapper parseDependencies() {
        if (null != data) {
            return data;
        }

        try {
            EnvironmentEndpoint.EnvironmentEntryDescriptor environmentEntryDescriptor = environmentEndpoint.environmentEntry("java.class.path");
            EnvironmentEndpoint.PropertySummaryDescriptor property = environmentEntryDescriptor.getProperty();

            if (null != property && null != property.getValue() && property.getValue() instanceof String) {
                String value = String.valueOf(property.getValue());
                String[] items = value.split(";");
                for (String item : items) {
                    String name = item.substring(item.lastIndexOf("\\") + 1);
                    DependencyItem dependency = new DependencyItem(name, item);
                    if (item.contains("cusc")) {
                        CU_SC.add(dependency);
                    } else {
                        OTHER.add(dependency);
                    }
                }
            }

            data = Wapper.wapper(CU_SC, OTHER);
        } catch (Exception ex) {
            LOGGER.error("不影响业务正常运行@ActuatorEnvHelper", ex);
            data = null;
        }

        return data;
    }

    @Getter
    @Setter
    class DependencyItem {
        String name;
        String path;

        public DependencyItem() {
        }

        public DependencyItem(String name, String path) {
            this.name = name;
            this.path = path;
        }

    }

}
