/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.rds.mybatis;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
public class CuscMyBatisPlusConfig
implements TransactionManagementConfigurer {
    @Resource
    private DataSource dataSource;
    @Value(value="${mybatis-plus.type-aliases-package:com/cusc/**/dao/entity}")
    private String aliasesPackage;
    @Value(value="${mybatis-plus.type-handlers-package:}")
    private String handlersPackage;

    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory() {
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(this.dataSource);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setCacheEnabled(true);
        configuration.setUseGeneratedKeys(false);
        configuration.setDefaultExecutorType(ExecutorType.REUSE);
        configuration.setLazyLoadingEnabled(false);
        configuration.setDefaultStatementTimeout(Integer.valueOf(5000));
        if (StringUtils.isNotEmpty((CharSequence)this.aliasesPackage)) {
            sqlSessionFactoryBean.setTypeAliasesPackage(this.aliasesPackage);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.handlersPackage)) {
            sqlSessionFactoryBean.setTypeHandlersPackage(this.handlersPackage);
        }
        sqlSessionFactoryBean.setConfiguration(configuration);
        try {
            sqlSessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:com/cusc/**/dao/mapper/*Mapper.xml"));
            sqlSessionFactoryBean.setPlugins(new Interceptor[]{this.paginationInterceptor()});
            return sqlSessionFactoryBean.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setCountSqlParser((ISqlParser)new JsqlParserCountOptimize(true));
        return paginationInterceptor;
    }

    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

