package com.cusc.nirvana.druid;

import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.cusc.nirvana.common.uid.UtilTools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author jeff.chen
 * @file CuscDruidConfig
 * @date 2021/10/25
 * @E-mail chenjf159@chinaunicom.cn
 */
@Configuration
@ConditionalOnProperty(name = "stat.druid.enabled", havingValue = "true")
public class CuscDruidConfig {

    static final Logger LOGGER = LoggerFactory.getLogger(CuscDruidConfig.class);

    @Value("${stat.druid.loginUserName:cusc@admin}")
    String longinUserName;

    @Value("${stat.druid.loginPassword:cusc@123}")
    String loginPassword;

    @Value("${stat.druid.allow:}")
    String allow;

    @Value("${stat.druid.deny:}")
    String deny;

    @Bean
    public ServletRegistrationBean statViewServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean(new StatViewServlet(), "/druid/*");
        Map<String, String> initParams = new HashMap<>();
        initParams.put("loginUsername", longinUserName);
        if (StringUtils.isNotBlank(loginPassword)) {
            initParams.put("loginPassword", loginPassword);
        } else {
            loginPassword = UtilTools.fixedLengthRandomHexString(8);
            initParams.put("loginPassword", loginPassword);
        }
        // 默认就是允许所有访问
        if (StringUtils.isNotBlank(allow)) {
            initParams.put("allow", allow);
        }

        // 黑名单IP
        if (StringUtils.isNotBlank(deny)) {
            initParams.put("deny", deny);
        }

        bean.setInitParameters(initParams);

        LOGGER.info("druid:http://127.0.0.1:10012/druid/index.html user-name:{} password:{} allow:{} deny:{}",
                longinUserName, loginPassword, allow, deny);

        return bean;
    }

    @Bean
    public FilterRegistrationBean webStatFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter(new WebStatFilter());
        Map<String, String> initParams = new HashMap<>();
        initParams.put("exclusions", "/static/*,*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        bean.setInitParameters(initParams);
        bean.setUrlPatterns(Arrays.asList("/*"));
        return bean;
    }

}
