/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.druid;

import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.cusc.nirvana.common.uid.UtilTools;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"stat.druid.enabled"}, havingValue="true")
public class CuscDruidConfig {
    static final Logger LOGGER = LoggerFactory.getLogger(CuscDruidConfig.class);
    @Value(value="${stat.druid.loginUserName:cusc@admin}")
    String longinUserName;
    @Value(value="${stat.druid.loginPassword:cusc@123}")
    String loginPassword;
    @Value(value="${stat.druid.allow:}")
    String allow;
    @Value(value="${stat.druid.deny:}")
    String deny;

    @Bean
    public ServletRegistrationBean statViewServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("loginUsername", this.longinUserName);
        if (StringUtils.isNotBlank((CharSequence)this.loginPassword)) {
            initParams.put("loginPassword", this.loginPassword);
        } else {
            this.loginPassword = UtilTools.fixedLengthRandomHexString((int)8);
            initParams.put("loginPassword", this.loginPassword);
        }
        if (StringUtils.isNotBlank((CharSequence)this.allow)) {
            initParams.put("allow", this.allow);
        }
        if (StringUtils.isNotBlank((CharSequence)this.deny)) {
            initParams.put("deny", this.deny);
        }
        bean.setInitParameters(initParams);
        LOGGER.info("druid:http://127.0.0.1:10012/druid/index.html user-name:{} password:{} allow:{} deny:{}", new Object[]{this.longinUserName, this.loginPassword, this.allow, this.deny});
        return bean;
    }

    @Bean
    public FilterRegistrationBean webStatFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new WebStatFilter());
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("exclusions", "/static/*,*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        bean.setInitParameters(initParams);
        bean.setUrlPatterns(Arrays.asList("/*"));
        return bean;
    }
}

