package com.cusc.nirvana.rds.mybatis;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

import javax.annotation.Resource;
import javax.sql.DataSource;

/**
 * @author jeff.chen
 * @file CuscMyBatisPlusConfig
 * @E-mail chenjf159@chinaunicom.cn
 */
@Configuration
public class CuscMyBatisPlusConfig implements TransactionManagementConfigurer {

    @Resource
    private DataSource dataSource;

    @Value("${mybatis-plus.type-aliases-package:com/cusc/**/dao/entity}")
    private String aliasesPackage;

    @Value("${mybatis-plus.type-handlers-package:}")
    private String handlersPackage;

    @Bean(name = "sqlSessionFactory")
    public SqlSessionFactory sqlSessionFactory() {
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);

        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setCacheEnabled(true);
        configuration.setUseGeneratedKeys(false);
        configuration.setDefaultExecutorType(ExecutorType.REUSE);
        configuration.setLazyLoadingEnabled(false);
        configuration.setDefaultStatementTimeout(5000);

        if (StringUtils.isNotEmpty(aliasesPackage)) {
            sqlSessionFactoryBean.setTypeAliasesPackage(aliasesPackage);
        }

        if (StringUtils.isNotEmpty(handlersPackage)) {
            sqlSessionFactoryBean.setTypeHandlersPackage(handlersPackage);
        }

        sqlSessionFactoryBean.setConfiguration(configuration);
        try {
            // 添加XML目录
            // sqlSessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver()
            //         .getResources("classpath*:com/cusc/nirvana/**/dao/mapper/*Mapper.xml,classpath*:/mapper/*Mapper.xml"));
            sqlSessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver()
                    .getResources("classpath*:com/cusc/**/dao/mapper/*Mapper.xml"));

            // 添加插件
            sqlSessionFactoryBean.setPlugins(new Interceptor[]{paginationInterceptor()});
            return sqlSessionFactoryBean.getObject();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setCountSqlParser(new JsqlParserCountOptimize(true));
        return paginationInterceptor;
    }

    @Override
    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

}
