package com.cusc.nirvana.common.result;

import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jeff.chen
 * @file BeanUtilsHelper
 * @date 2021/9/23
 * @E-mail chenjf159@chinaunicom.cn
 */
public class BeanUtilsHelper {

    public static <T, S> List<S> convert(List<T> list, Class<S> clz) {
        List<S> result = new ArrayList<>();
        list.forEach(item -> {
            S obj = null;
            try {
                obj = clz.newInstance();
            } catch (InstantiationException e) {
                e.printStackTrace();
                return;
            } catch (IllegalAccessException e) {
                e.printStackTrace();
                return;
            }
            BeanUtils.copyProperties(item, obj);
            result.add(obj);
        });

        return result;
    }

}
