/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.nacos;

import com.alibaba.cloud.nacos.ConditionalOnNacosDiscoveryEnabled;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.cusc.nirvana.common.evn.EnvHelper;
import com.cusc.nirvana.nacos.NacosAddressList;
import com.cusc.nirvana.nacos.NacosDefaultConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnDiscoveryEnabled
@ConditionalOnNacosDiscoveryEnabled
public class NacosDiscoveryCuscConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(NacosDiscoveryCuscConfiguration.class);
    @Autowired
    private Environment environment;

    @Bean
    public NacosDiscoveryProperties cuscNacosDiscoveryProperties(ApplicationContext context) {
        NacosDiscoveryProperties nacosDiscoveryProperties = context.getParent() != null && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getParent(), NacosDiscoveryProperties.class).length > 0 ? (NacosDiscoveryProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)context.getParent(), NacosDiscoveryProperties.class) : new NacosDiscoveryProperties();
        NacosDefaultConfig discoveryConf = NacosAddressList.getDiscoveryAddress(EnvHelper.getInstance().getCurrentEnv());
        String serverAddr = this.environment.resolvePlaceholders("${spring.cloud.nacos.discovery.server-addr:}");
        if (StringUtils.isEmpty((Object)serverAddr)) {
            serverAddr = this.environment.resolvePlaceholders("${spring.cloud.nacos.server-addr:}");
        }
        if (StringUtils.isEmpty((Object)serverAddr)) {
            serverAddr = discoveryConf.serverAddr;
        }
        nacosDiscoveryProperties.setServerAddr(serverAddr);
        String namespace = this.environment.resolvePlaceholders("${spring.cloud.nacos.discovery.namespace:}");
        if (StringUtils.isEmpty((Object)namespace)) {
            namespace = this.environment.resolvePlaceholders("${spring.cloud.nacos.namespace:}");
        }
        if (StringUtils.isEmpty((Object)namespace)) {
            namespace = discoveryConf.namespace;
        }
        nacosDiscoveryProperties.setNamespace(namespace);
        String username = this.environment.resolvePlaceholders("${spring.cloud.nacos.discovery.username:}");
        if (StringUtils.isEmpty((Object)username)) {
            username = this.environment.resolvePlaceholders("${spring.cloud.nacos.username:}");
        }
        if (StringUtils.isEmpty((Object)username)) {
            username = discoveryConf.username;
        }
        nacosDiscoveryProperties.setUsername(username);
        String password = this.environment.resolvePlaceholders("${spring.cloud.nacos.discovery.password:}");
        if (StringUtils.isEmpty((Object)password)) {
            password = this.environment.resolvePlaceholders("${spring.cloud.nacos.password:}");
        }
        if (StringUtils.isEmpty((Object)password)) {
            password = discoveryConf.password;
        }
        nacosDiscoveryProperties.setPassword(password);
        logger.info("nacos.discovery env:{} server-addr:{} namespace:{}", new Object[]{EnvHelper.getInstance().getCurrentEnv(), nacosDiscoveryProperties.getServerAddr(), nacosDiscoveryProperties.getNamespace()});
        return nacosDiscoveryProperties;
    }
}

