/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.nacos;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.cusc.nirvana.common.evn.EnvHelper;
import com.cusc.nirvana.nacos.NacosAddressList;
import com.cusc.nirvana.nacos.NacosDefaultConfig;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.nacos.config.enabled"}, matchIfMissing=true)
public class NacosConfigCuscConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(NacosConfigCuscConfiguration.class);
    @Autowired
    @JsonIgnore
    private Environment environment;

    @Bean
    public NacosConfigProperties cuscNacosConfigProperties(ApplicationContext context) {
        NacosConfigProperties nacosConfigProperties = context.getParent() != null && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getParent(), NacosConfigProperties.class).length > 0 ? (NacosConfigProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)context.getParent(), NacosConfigProperties.class) : new NacosConfigProperties();
        nacosConfigProperties.setFileExtension("yml");
        NacosDefaultConfig configConf = NacosAddressList.getConfigAddress(EnvHelper.getInstance().getCurrentEnv());
        String serverAddr = this.environment.resolvePlaceholders("${spring.cloud.nacos.config.server-addr:}");
        if (StringUtils.isEmpty((Object)serverAddr)) {
            serverAddr = this.environment.resolvePlaceholders("${spring.cloud.nacos.server-addr:}");
        }
        if (StringUtils.isEmpty((Object)serverAddr)) {
            serverAddr = configConf.serverAddr;
        }
        nacosConfigProperties.setServerAddr(serverAddr);
        String username = this.environment.resolvePlaceholders("${spring.cloud.nacos.config.username:}");
        if (StringUtils.isEmpty((Object)username)) {
            username = this.environment.resolvePlaceholders("${spring.cloud.nacos.username:}");
        }
        if (StringUtils.isEmpty((Object)username)) {
            username = configConf.username;
        }
        nacosConfigProperties.setUsername(username);
        String password = this.environment.resolvePlaceholders("${spring.cloud.nacos.config.password:}");
        if (StringUtils.isEmpty((Object)password)) {
            password = this.environment.resolvePlaceholders("${spring.cloud.nacos.password:}");
        }
        if (StringUtils.isEmpty((Object)password)) {
            password = configConf.password;
        }
        nacosConfigProperties.setPassword(password);
        String namespace = this.environment.resolvePlaceholders("${spring.cloud.nacos.config.namespace:}");
        if (StringUtils.isEmpty((Object)namespace)) {
            namespace = this.environment.resolvePlaceholders("${spring.cloud.nacos.namespace:}");
        }
        if (StringUtils.isEmpty((Object)namespace)) {
            namespace = configConf.namespace;
        }
        nacosConfigProperties.setNamespace(namespace);
        logger.info("nacos.config env:{} server-addr:{} namespace:{}", new Object[]{EnvHelper.getInstance().getCurrentEnv(), nacosConfigProperties.getServerAddr(), nacosConfigProperties.getNamespace()});
        return nacosConfigProperties;
    }
}

