package com.cusc.nirvana.nacos.config;

import java.util.HashMap;
import java.util.Iterator;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

/**
 * @author jeff.chen
 * @file CuscSharedConfigEnvironmentPostProcessor
 * @date 2021/10/13
 * @E-mail chenjf159@chinaunicom.cn
 */
public class CuscSharedConfigEnvironmentPostProcessor implements EnvironmentPostProcessor {

    static final String PASS_PROPERTY_SOURCE = "org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource";

    static final String KEY_APPLICATION_NAME = "spring.application.name";

    static final String DATA_ID_PREFIX = "spring.cloud.nacos.config.shared-configs[";
    static final String DATA_ID_SUFFIX = "].data-id";

    static final String GROUP_PREFIX = "spring.cloud.nacos.config.shared-configs[";
    static final String GROUP_SUFFIX = "].group";

    static final String REFRESH_PREFIX = "spring.cloud.nacos.config.shared-configs[";
    static final String REFRESH_SUFFIX = "].refresh";

    static final String DEFAULT_SHARED_CONFIG = "shared-config.yml";

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Iterator<PropertySource<?>> iterator = environment.getPropertySources().iterator();
        while (iterator.hasNext()) {
            PropertySource propertySource = iterator.next();
            if (PASS_PROPERTY_SOURCE.equals(propertySource.getClass().getName())) {
                continue;
            }

            if (propertySource.containsProperty(KEY_APPLICATION_NAME)) {
                Object source = propertySource.getSource();
                if (source instanceof HashMap) {
                    HashMap map = (HashMap) source;
                    if (!map.containsKey(KEY_APPLICATION_NAME)) {
                        continue;
                    }

                    for (int i = 0; i < map.size(); i++) {
                        String keyDataId = DATA_ID_PREFIX + i + DATA_ID_SUFFIX;
                        String keyRefresh = REFRESH_PREFIX + i + REFRESH_SUFFIX;
                        if (map.containsKey(keyDataId)) {
                            Object value = map.get(keyDataId);
                            if (value instanceof OriginTrackedValue) {
                                OriginTrackedValue value0 = (OriginTrackedValue) value;
                                if (DEFAULT_SHARED_CONFIG.equals(String.valueOf(value0.getValue()))) {
                                    break;
                                }
                            }
                        } else {
                            map.put(keyDataId, DEFAULT_SHARED_CONFIG);
                            map.put(keyRefresh, true);
                            break;
                        }
                    }
                }
            }
        }
    }

}
