package com.cusc.nirvana.nacos;

import com.alibaba.cloud.nacos.ConditionalOnNacosDiscoveryEnabled;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.cusc.nirvana.common.evn.EnvHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

/**
 * @author jeff.chen
 * @file NacosDiscoveryCuscConfiguration
 * @date 2021/9/24
 * @E-mail chenjf159@chinaunicom.cn
 */
@Configuration
@ConditionalOnDiscoveryEnabled
@ConditionalOnNacosDiscoveryEnabled
public class NacosDiscoveryCuscConfiguration {

    private final static Logger logger = LoggerFactory.getLogger(NacosDiscoveryCuscConfiguration.class);

    @Autowired
    private Environment environment;

    @Bean
    public NacosDiscoveryProperties cuscNacosDiscoveryProperties(ApplicationContext context) {
        NacosDiscoveryProperties nacosDiscoveryProperties;
        if (context.getParent() != null
                && BeanFactoryUtils.beanNamesForTypeIncludingAncestors(
                context.getParent(), NacosDiscoveryProperties.class).length > 0) {
            nacosDiscoveryProperties = BeanFactoryUtils.beanOfTypeIncludingAncestors(context.getParent(),
                    NacosDiscoveryProperties.class);
        } else {
            nacosDiscoveryProperties = new NacosDiscoveryProperties();
        }

        NacosDefaultConfig discoveryConf = NacosAddressList.getDiscoveryAddress(EnvHelper.getInstance().getCurrentEnv());

        String serverAddr = environment.resolvePlaceholders("${spring.cloud.nacos.discovery.server-addr:}");
        if (StringUtils.isEmpty(serverAddr)) {
            serverAddr = environment.resolvePlaceholders("${spring.cloud.nacos.server-addr:}");
        }
        if (StringUtils.isEmpty(serverAddr)) {
            serverAddr = discoveryConf.serverAddr;
        }
        nacosDiscoveryProperties.setServerAddr(serverAddr);

        String namespace = environment.resolvePlaceholders("${spring.cloud.nacos.discovery.namespace:}");
        if (StringUtils.isEmpty(namespace)) {
            namespace = environment.resolvePlaceholders("${spring.cloud.nacos.namespace:}");
        }
        if (StringUtils.isEmpty(namespace)) {
            namespace = discoveryConf.namespace;
        }
        nacosDiscoveryProperties.setNamespace(namespace);


        String username = environment.resolvePlaceholders("${spring.cloud.nacos.discovery.username:}");
        if (StringUtils.isEmpty(username)) {
            username = environment.resolvePlaceholders("${spring.cloud.nacos.username:}");
        }
        if (StringUtils.isEmpty(username)) {
            username = discoveryConf.username;
        }
        nacosDiscoveryProperties.setUsername(username);

        String password = environment.resolvePlaceholders("${spring.cloud.nacos.discovery.password:}");
        if (StringUtils.isEmpty(password)) {
            password = environment.resolvePlaceholders("${spring.cloud.nacos.password:}");
        }
        if (StringUtils.isEmpty(password)) {
            password = discoveryConf.password;
        }
        nacosDiscoveryProperties.setPassword(password);


        logger.info("nacos.discovery env:{} server-addr:{} namespace:{}",
                EnvHelper.getInstance().getCurrentEnv(),
                nacosDiscoveryProperties.getServerAddr(),
                nacosDiscoveryProperties.getNamespace());

        return nacosDiscoveryProperties;
    }

}
