/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.nacos.config;

import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class CuscSharedConfigEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    static final String PASS_PROPERTY_SOURCE = "org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource";
    static final String KEY_APPLICATION_NAME = "spring.application.name";
    static final String DATA_ID_PREFIX = "spring.cloud.nacos.config.shared-configs[";
    static final String DATA_ID_SUFFIX = "].data-id";
    static final String GROUP_PREFIX = "spring.cloud.nacos.config.shared-configs[";
    static final String GROUP_SUFFIX = "].group";
    static final String REFRESH_PREFIX = "spring.cloud.nacos.config.shared-configs[";
    static final String REFRESH_SUFFIX = "].refresh";
    static final String DEFAULT_SHARED_CONFIG = "shared-config.yml";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        block0: for (PropertySource propertySource : environment.getPropertySources()) {
            HashMap map;
            Object source;
            if (PASS_PROPERTY_SOURCE.equals(propertySource.getClass().getName()) || !propertySource.containsProperty(KEY_APPLICATION_NAME) || !((source = propertySource.getSource()) instanceof HashMap) || !(map = (HashMap)source).containsKey(KEY_APPLICATION_NAME)) continue;
            for (int i = 0; i < map.size(); ++i) {
                String keyDataId = "spring.cloud.nacos.config.shared-configs[" + i + DATA_ID_SUFFIX;
                String keyRefresh = "spring.cloud.nacos.config.shared-configs[" + i + REFRESH_SUFFIX;
                if (map.containsKey(keyDataId)) {
                    OriginTrackedValue value0;
                    Object value = map.get(keyDataId);
                    if (!(value instanceof OriginTrackedValue) || !DEFAULT_SHARED_CONFIG.equals(String.valueOf((value0 = (OriginTrackedValue)value).getValue()))) continue;
                    continue block0;
                }
                map.put(keyDataId, DEFAULT_SHARED_CONFIG);
                map.put(keyRefresh, true);
                continue block0;
            }
        }
    }
}

