package com.cusc.nirvana.nacos;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.cusc.nirvana.common.evn.EnvHelper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

/**
 * @author jeff.chen
 * @file NacosConfigCuscConfiguration
 * @date 2021/9/24
 * @E-mail chenjf159@chinaunicom.cn
 */
@Configuration
@ConditionalOnProperty(name = "spring.cloud.nacos.config.enabled", matchIfMissing = true)
public class NacosConfigCuscConfiguration {

    private final static Logger logger = LoggerFactory.getLogger(NacosConfigCuscConfiguration.class);

    @Autowired
    @JsonIgnore
    private Environment environment;

    @Bean
    public NacosConfigProperties cuscNacosConfigProperties(ApplicationContext context) {
        NacosConfigProperties nacosConfigProperties;
        if (context.getParent() != null
                && BeanFactoryUtils.beanNamesForTypeIncludingAncestors(
                context.getParent(), NacosConfigProperties.class).length > 0) {
            nacosConfigProperties = BeanFactoryUtils.beanOfTypeIncludingAncestors(context.getParent(),
                    NacosConfigProperties.class);
        } else {
            nacosConfigProperties = new NacosConfigProperties();
        }

        // default
        nacosConfigProperties.setFileExtension("yml");

        NacosDefaultConfig configConf = NacosAddressList.getConfigAddress(EnvHelper.getInstance().getCurrentEnv());

        String serverAddr = environment.resolvePlaceholders("${spring.cloud.nacos.config.server-addr:}");
        if (StringUtils.isEmpty(serverAddr)) {
            serverAddr = environment.resolvePlaceholders("${spring.cloud.nacos.server-addr:}");
        }
        if (StringUtils.isEmpty(serverAddr)) {
            serverAddr = configConf.serverAddr;
        }
        nacosConfigProperties.setServerAddr(serverAddr);

        String username = environment.resolvePlaceholders("${spring.cloud.nacos.config.username:}");
        if (StringUtils.isEmpty(username)) {
            username = environment.resolvePlaceholders("${spring.cloud.nacos.username:}");
        }
        if (StringUtils.isEmpty(username)) {
            username = configConf.username;
        }
        nacosConfigProperties.setUsername(username);

        String password = environment.resolvePlaceholders("${spring.cloud.nacos.config.password:}");
        if (StringUtils.isEmpty(password)) {
            password = environment.resolvePlaceholders("${spring.cloud.nacos.password:}");
        }
        if (StringUtils.isEmpty(password)) {
            password = configConf.password;
        }
        nacosConfigProperties.setPassword(password);

        String namespace = environment.resolvePlaceholders("${spring.cloud.nacos.config.namespace:}");
        if (StringUtils.isEmpty(namespace)) {
            namespace = environment.resolvePlaceholders("${spring.cloud.nacos.namespace:}");
        }
        if (StringUtils.isEmpty(namespace)) {
            namespace = configConf.namespace;
        }
        nacosConfigProperties.setNamespace(namespace);

        logger.info("nacos.config env:{} server-addr:{} namespace:{}",
                EnvHelper.getInstance().getCurrentEnv(),
                nacosConfigProperties.getServerAddr(),
                nacosConfigProperties.getNamespace());

        return nacosConfigProperties;
    }

}
